#!/bin/bash
ls_isactive=`systemctl is-active docker`
if [ "$ls_isactive" != "active" ];then
   echo "error:16/docker service is stop"
else
   ls_temp=`docker ps -a -s --format  'table {{.Names}}\t{{.Status}}\t{{.Size}}' | sed '1d' | grep -w $1`
   if [ "$ls_temp" != "" ];then
      ls_status=`echo $ls_temp | awk '{print $2}'`
      ls_size=`echo $ls_temp | awk -F "virtual " '{print $NF}'| awk -F ")" '{print $1}'`
      ls_port=`docker port $1`
      ls_temp=`docker stats --no-stream --format  'table {{.CPUPerc}}\t{{.MemUsage}}' $1 | sed '1d'`
      #ls_temp=`docker stats --no-stream $1 | sed '1d'` 
      ls_cpu=`echo $ls_temp | awk '{print $1}'` 
      ls_mem=`echo $ls_temp | awk '{print $2}'`
      if [[ ! "$ls_mem" =~ "B" ]];then
         ls_unit=`echo $ls_temp | awk '{print $3}'`
         ls_mem=`echo "$ls_mem""$ls_unit"`   
      fi
      #echo $ls_status"+"$ls_size"+"$ls_port"+"$ls_cpu"+"$ls_mem
      echo $ls_status"/"$ls_size"/"$ls_cpu"/"$ls_mem
   else
      echo "error:11/no docker $1"
   fi
fi
