################ ver test ##################
#!/bin/bash
OLD_IFS=${IFS}
IFS=$'\n'
getparameter()
{
  ################ server ##############
  ls_temp="[server]"
  ls_line=`cat $1 | awk -v var1=$ls_temp 'BEGIN {a=0}$0!~/^[[:blank:]]+$|^$/ {if (a==1) if (!match($0,/\[/)) {print $0} else {exit} else if ($0==var1) {a=1}}'`
  for ls_templine in ${ls_line}
  do
    ls_temp=${ls_templine%=*}
    if [[ ${ls_temp} == "url" ]];then
       ls_serverurl=${ls_templine#*=}
    fi
  done
  echo $ls_serverurl
  ################ parameter ###########
  ls_temp="[parameter]"
  ls_line=`cat $1 | awk -v var1=$ls_temp 'BEGIN {a=0}$0!~/^[[:blank:]]+$|^$/ {if (a==1) if (!match($0,/\[/)) {print $0} else {exit} else if ($0==var1) {a=1}}'`
  for ls_templine in ${ls_line}
  do
    ls_temp=${ls_templine%%=*}
    case ${ls_temp} in
    msginterval)
         ls_msginterval=${ls_templine#*=}
    ;;
    log)
         ls_log=${ls_templine#*=}
    ;;
    sn)
         ls_sn=${ls_templine#*=}
    ;;
    vpnactived)
         ls_vpnactived=${ls_templine#*=} ### 0 inactive
    ;;
    interface)
         ls_interface=${ls_templine#*=}
    ;;
    vinterface)
         ls_vinterface=${ls_templine#*=}    
    ;;
    ver)
         ls_ver=${ls_templine#*=}
    ;;
    vpnclientpaskey)
         ls_vpnclientpaskey=${ls_templine#*=}
    ;;
    clientwebserverhost)
         ls_clientwebserver=${ls_templine#*=}
   
         if [[ "${ls_clientwebserver}" == "0" ]];then
            ls_remotewebenable="0"
         else
            ls_remotewebenable="1"
         fi
         echo "hello world setup ls_remotewebenable "${ls_remotewebenable}
    ;;
    clientwebserverport)
         ls_clientwebserverport=${ls_templine#*=}
    ;;
    clientwebport)
         ls_clientwebport=${ls_templine#*=}
    ;;
    clientwebuser)
         ls_clientwebuser=${ls_templine#*=}
    ;;
    clientwebpas)
         ls_clientwebpas=${ls_templine#*=} 
         ls_webpas=`echo  ${ls_clientwebpas} | openssl enc -d -md sha256 -aes-256-cbc -a -nosalt -k ${ls_vpnclientpaskey} 2>/dev/null`
         echo ${ls_webpas}
    ;;
    esac
  done
  echo $ls_serverurl $ls_msginterval $ls_log $ls_sn $ls_actived $ls_interface $ls_ver $ls_clientwebuser $ls_clientwebpas $ls_clientwebserver
}

getcpuused()
{
#  li_cpuused=`top -bn 1 -i -c | head -n 3|grep id | awk -F "," '{print $4}' | awk '{printf "%.1f", 100-$1}'`
  li_cpuused=`top -bn 1  | head -n 3|grep id | awk -F "," '{print $4}' | awk '{printf "%.1f", 100-$1}'`
  #echo "cpuused:"${li_cpuused}
}

getmemused()
{
  li_memtotal=`free -l | grep "Mem" | awk '{print $2}'`
  li_memused=`free -l | grep "Mem" | awk '{print $3}'`
  li_mempercent=$(($li_memused*100/$li_memtotal))
  #echo "memused:"${li_percent}
}

getipmac()
{
  ls_ip=`ip a sh ${ls_interface}| head -n 3 | grep inet | awk '{print $2}'`
  ls_mac=`ip a sh ${ls_interface} | head -n 3 | grep link/ether | awk '{print $2}'`
  ls_vip=`ip a sh ${ls_vinterface}| head -n 3 | grep inet | awk '{print $2}'`
  ls_vmac=`ip a sh ${ls_vinterface} | head -n 3 | grep link/ether | awk '{print $2}'`  
}

getcimi()
{
  ls_cimi=`wget -q -O - "http://127.0.0.1/get.cgi&modem_cimi"` 
  ls_cimi=${ls_cimi#*=}
}

urlencode() {
local LANG=C
local length="${#1}"
i=0
while :
do
[ $length -gt $i ]&&{
local c="${1:$i:1}"
case $c in
[a-zA-Z0-9.~_-]) printf "$c" ;;
*) printf '%%%02X' "'$c" ;;
esac
}||break
let i++
done
}



send()
{
  while :
  do
    getcpuused
    getmemused
    getipmac
    getcimi
  #  if [ ${ls_vpnactived} == "1" ];then
  #     ls_ip="192.168.101.1/24"
       ls_send=${ls_sn}","${ls_vip}","${ls_vmac}","${ls_ip}","${ls_mac}","${li_cpuused}","${li_mempercent}","${ls_ver}","$(date +%s)","${ls_cimi}
       echo "send:${ls_sn}@${ls_send}"
       ls_send=$(encrypt ${ls_send})
       ls_send=$(urlencode ${ls_send})
       echo "send(pas encoded):${ls_sn}@${ls_send}"
       #ls_return=`curl ${ls_serverurl}?data="${ls_sn}@${ls_send}"`
       ls_return=`wget -q -O - ${ls_serverurl}?data="${ls_sn}@${ls_send}"`
       if [[ $? -eq 0 && "${ls_return}" != null ]];then
         echo "return: ${ls_return}"
         ls_return=`echo ${ls_return} | awk -F "\"" '{print $2}'`
         ls_return=$(decrypt ${ls_return})
         echo "return(decrypt):${ls_return}"
         receive ${ls_return}
       fi
   # fi
    sleep ${ls_msginterval}s
  done
}

receive()
{
  echo "ls_receive:"$1 
  #ls_dev=`echo $1 | awk '{print $1}' |awk -F "\"" '{print $2}'`
  ls_dev=`echo $1 | awk -F "," '{print $1}'`
  echo "ls_dev:"${ls_dev}
  if [ "${ls_dev}" == "${ls_sn}" ];then
     ls_fun=`echo $1 | awk -F "," '{print $2}'`
     echo "ls_fun:"${ls_fun}
     case "${ls_fun}" in
       1) ############## update the ovpn ###############
          echo "update the ovpn"
          ls_dev=`echo $1 | awk -F "," '{print $3}'`
          ls_proto=`echo $1 | awk -F "," '{print $4}'`
          ls_vpnIP=`echo $1 | awk -F "," '{print $5}'`
          ls_vpnPort=`echo $1 | awk -F "," '{print $6}'`           
          ls_logLevel=`echo $1 | awk -F "," '{print $7}'`              
          ls_compress=`echo $1 | awk -F "," '{print $8}'`
          ls_shaper=`echo $1 | awk -F "," '{print $9}'`
          ls_ovpn=${ls_shellpath}/client.ovpn
          sed -i "/dev/c\dev ${ls_dev}" ${ls_ovpn}
          sed -i "/proto/c\proto ${ls_proto}" ${ls_ovpn}
          sed -i  "/remote /c\remote ${ls_vpnIP} ${ls_vpnPort}" ${ls_ovpn}
          sed -i "/compress /c\compress ${ls_compress}" ${ls_ovpn}
          sed -i "/verb /c\verb ${ls_logLevel}" ${ls_ovpn}
          sed -i "/shaper /c\shaper ${ls_shaper}" ${ls_ovpn}
          echo "analysis:${ls_dev} ${ls_proto} ${ls_vpnIP} ${ls_vpnPort} ${ls_compress} ${ls_logLevel} ${ls_compress} ${ls_shaper}"
          killvpn
          {
            sleep 1s
            operate
          } &
          reboot
       ;;
       2) ############## reboot ###############
          reboot 
       ;;
       3) ############## update the sign #######
          echo "update the sign"
       ;;
       4)
          ############## update the pass #######
          echo "update the pass"
       ;;
       5)
          ############## update the sw #########
          echo "update the sw"
          #ls_updateUrl=`echo $1 | awk '{print $3}' | awk -F "\"" '{print $1}'`
          ls_updateUrl=`echo $1 | awk '{print $3}'`
          echo ${ls_updateUrl}
          ls_updateFile=${ls_updateUrl##*/}
          wget ${ls_updateUrl} -O ${ls_updateFile}
          if [ $? == 0 ];then
             #openssl des3 -d -k ${ls_updatepas} -salt -in ${ls_updateFile} | tar zxvf - -C ${ls_shellpath}/
             openssl enc -d -md sha256 -aes-256-cbc -salt -k ${ls_updatepas} -in ${ls_shellpath}/${ls_updateFile} |tar xzvf - -C ${ls_shellpath}/
             if [ $? == 0 ];then
                echo "ok:update "${ls_shellpath}/${ls_updateFile}    
             else
                echo "error:update "${ls_shellpath}/${ls_updateFile}
             fi
             rm -f ${ls_shellpath}/${ls_updateFile}
             if [ $? == 0 ];then
                echo "ok:rm "${ls_shellpath}/${ls_updateFile}
             else
                echo "error:rm "${ls_shellpath}/${ls_updateFile}
             fi
             echo "rebooting..."
             reboot
             
          fi  
       ;;
       #6) 
         ############### update the webport ########
       #  echo "update the webport"
       #  ls_clientwebserver=`echo $1 | awk -F "," '{print $3}'`
       #  ls_clientwebserverport=`echo $1 | awk -F "," '{print $4}'`
       #  ls_clientwebuser=`echo $1 | awk -F "," '{print $5}'`
       #  ls_clientwebport=`echo $1 | awk -F "," '{print $6}'`
       #  sed -i "/clientwebserver=/c\clientwebserver=${ls_clientwebserver}" ${ls_shellpath}/setup.ini
       #  sed -i "/clientwebserverport=/c\clientwebserverport=${ls_clientwebserverport}" ${ls_shellpath}/setup.ini
       #  sed -i "/clientwebuser=/c\clientwebuser=${ls_clientwebuser}" ${ls_shellpath}/setup.ini
       #  sed -i "/clientwebport=/c\clientwebport=${ls_clientwebport}" ${ls_shellpath}/setup.ini
         
       #  echo $ls_clientwebserver $ls_clientwebserverport $ls_clientwebport
         #ssh -i /etc/storage/dropbear/rsa_host_key -y -fNg -R *:${ls_clientwebport}:127.0.0.1:80 root@${ls_clientwebserver} -p ${ls_clientwebserverport}
       #  killssh
       #  reboot
       #;;
       7)
         ##############  vpn ################
         ls_vpnactived=`echo $1 | awk -F "," '{print $3}'`
         if [ ${ls_vpnactived} -eq 1 ];then
            vpnpid=`ps wlT | grep "openvpn --config ${ls_shellpath}/client.ovpn" |grep -v "grep"| awk '{print $3}'`
            if [ "${vpnpid}" == "" ];then
               echo "active the vpn"
               sed -i '/vpnactived/c\vpnactived=1' ${ls_shellpath}/setup.ini
               reboot
            fi
            
         else

            sed -i '/vpnactived/c\vpnactived=0' ${ls_shellpath}/setup.ini
            echo "disable the vpn"
            reboot
         fi
        ;;
       8)
        ############### setup ############
        echo "update the setup"
        ls_ver=`echo $1 | awk -F "," '{print $3}'`
        ls_url=`echo $1 | awk -F "," '{print $4}'`
        ls_msginterval=`echo $1 | awk -F "," '{print $5}'`
        ls_interface=`echo $1 | awk -F "," '{print $6}'`

        ls_clientwebserver=`echo $1 | awk -F "," '{print $7}'`
        ls_clientwebserverport=`echo $1 | awk -F "," '{print $8}'`
        ls_clientwebport=`echo $1 | awk -F "," '{print $9}'`
        ls_clientwebuser=`echo $1 | awk -F "," '{print $10}'`
        ls_vpnactived=`echo $1 | awk -F "," '{print $11}'`
        sed -i "/ver=/c\ver=${ls_ver}" ${ls_shellpath}/setup.ini
        sed -i "/url=/c\url=${ls_url}" ${ls_shellpath}/setup.ini
        sed -i "/msginterval=/c\msginterval=${ls_msginterval}" ${ls_shellpath}/setup.ini
        sed -i "/^interface=/c\interface=${ls_interface}" ${ls_shellpath}/setup.ini
        sed -i "/vpnactived=/c\vpnactived=${ls_vpnactived}" ${ls_shellpath}/setup.ini         
        sed -i "/clientwebserverhost=/c\clientwebserverhost=${ls_clientwebserver}" ${ls_shellpath}/setup.ini
        sed -i "/clientwebserverport=/c\clientwebserverport=${ls_clientwebserverport}" ${ls_shellpath}/setup.ini
        sed -i "/clientwebport=/c\clientwebport=${ls_clientwebport}" ${ls_shellpath}/setup.ini
        sed -i "/clientwebuser=/c\clientwebuser=${ls_clientwebuser}" ${ls_shellpath}/setup.ini        
        reboot
        ;;
       *)
          ############## other ################
          echo "error:no fun"
       ;;
     esac
     
  fi
}

operate()
{
  if [ ${ls_vpnactived} == "1" ];then
     openvpn --config ${ls_shellpath}/client.ovpn
  fi
}

encrypt()
{
  let li_maxlen=46
  ls_temp=$1
  ls_templen=${#ls_temp}
  li_n=$((ls_templen/li_maxlen))
  ls_encryptresult=""
  for li_i in `seq 0 ${li_n}`
  do
    li_start=$((li_i*li_maxlen))
    ls_text=${ls_temp:${li_start}:${li_maxlen}}
    ls_encryption=`echo ${ls_text} | openssl enc -e -md sha256 -aes-256-cbc  -a -nosalt -k ${ls_vpnclientpaskey} 2>/dev/null`
    ls_encryptresult=`echo ${ls_encryptresult}${ls_encryption}`
  done
  echo ${ls_encryptresult}
}

decrypt()
{
  let li_len=64
  local ls_temp
  local ls_tempstr
  local ls_result
  local ls_next
  local ls_temp
  local ls_result
  ls_temp=$1
  local li_strlen
  let li_strlen=${#ls_temp}
  if [ ${li_strlen} -gt ${li_len} ];then
     ls_tempstr=${ls_temp:0:${li_len}}
     ls_result=`echo ${ls_tempstr} | openssl enc -d -md sha256 -aes-256-cbc  -a -nosalt -k ${ls_vpnclientpaskey} 2>/dev/null`
     ls_temp1=${ls_temp:${li_len}}
     ls_next=$(decrypt ${ls_temp:${li_len}})
     echo  ${ls_result}${ls_next}
  else
    ls_result=`echo ${ls_temp} | openssl enc -d -md sha256 -aes-256-cbc  -a -nosalt -k ${ls_vpnclientpaskey} 2>/dev/null`
    echo  ${ls_result}
  fi  
}

killvpn()
{
  oldvpnpid=`ps wlT | grep "openvpn --config ${ls_shellpath}/client.ovpn" |grep -v "grep"| awk '{print $3}'`
  for ls_pid in ${oldvpnpid}
  do
    if [[ "${ls_pid}" != "" ]];then
       kill -9 ${ls_pid}
    fi
  done
}


clientweb()
{
   while :
   do
     oldsshpid=`ps wlT | grep "sshpass -p" | grep -v "grep"|awk '{print $3}'`
     #echo "oldsshpid:"${oldsshpid}
     if [ "${oldsshpid}" == "" ];then
         #ls_sshresult=`ssh -i /etc/storage/dropbear/rsa_host_key -K 2 -I 10  -y -fNg -R *:${ls_clientwebport}:127.0.0.1:80 root@${ls_clientwebserver} -p ${ls_clientwebserverport}`
         #echo "password:${ls_webpas}"
         sshpass -p "${ls_webpas}" ssh -y  -K 3 -I 10 -Ng  -R *:${ls_clientwebport}:127.0.0.1:80  ${ls_clientwebuser}@${ls_clientwebserver} -p ${ls_clientwebserverport}
         echo "ssh return:${ls_sshresult}"
     fi
     sleep 1s
   done
}
killssh()
{
  oldsshpid=`ps wlT | grep "sshpass -p" |grep -v "grep"| awk '{print $3}'`
  if [ "${oldsshpid}" != "" ];then
     kill -9 ${oldsshpid}
  fi

}
ls_shellpath=$(cd $(dirname $0);pwd)
getparameter ${ls_shellpath}/setup.ini
#if [ ${ls_vpnactived} -eq 1 ];then
killssh
echo "hello world remotewebenable "${ls_remotewebenable}
if [[ "${ls_remotewebenable}" == "1" ]];then
{
 clientweb
} &
fi

killvpn
{
 operate
} &
send
killssh
#fi
IFS=${OLD_IFS}
